TITLE   'Sinusoidal Volume Heating of a Steel Foil' 		{ exa202.pde }
SELECT     							
   errlim=3e-5     spectral_colors
COORDINATES
   cartesian1						{ 1D }
VARIABLES     tempr     tempi
DEFINITIONS
   Lx=0.2 k=45     rcp=3e6     heat=1e6		{ Real value }
   omega=0.25                  				{ Angular frequency }
   tempa=sqrt(tempr^2+ tempi^2)     		{ Amplitude }
   phase=sign(tempi)*arccos(tempr/tempa)/pi*180
EQUATIONS
   tempr:	dx(-k*dx( tempr))- omega*rcp*tempi=heat
   tempi:	dx(-k*dx( tempi))+ omega*rcp*tempr=0
BOUNDARIES
region 'domain'
   start (0) point value( tempr)=0 point value( tempi)=0
   line to (Lx) point value( tempr)=0 point value( tempi)=0
PLOTS
   elevation( tempr, tempi) from (0) to (Lx)
   elevation( phase) from (0) to (Lx)
   elevation( abs(tempr), abs(tempi), abs(tempa)) log
      from (0.001*Lx) to (0.999*Lx)
END



